<?php
require_once 'db.php';
require_once 'config.php';

$pdo = getDB();
$total_users = $pdo->query("SELECT COUNT(*) as c FROM users")->fetch()['c'] ?? 0;
$total_balance = $pdo->query("SELECT SUM(balance) as s FROM users")->fetch()['s'] ?? 0;
$total_withdrawals = $pdo->query("SELECT COUNT(*) as c FROM withdrawals")->fetch()['c'] ?? 0;
?>

<?php include 'header.php'; ?>

<div class="p-4">
  <h1 class="text-2xl font-bold mb-4">Dashboard</h1>
  <div class="grid grid-cols-1 sm:grid-cols-3 gap-4">
    <div class="bg-white shadow rounded p-4 animate-fadeIn">
      <h2 class="font-semibold">Total Users</h2>
      <p class="text-2xl"><?=$total_users?></p>
    </div>
    <div class="bg-white shadow rounded p-4 animate-fadeIn">
      <h2 class="font-semibold">Total Balance</h2>
      <p class="text-2xl">₹<?=$total_balance?></p>
    </div>
    <div class="bg-white shadow rounded p-4 animate-fadeIn">
      <h2 class="font-semibold">Total Withdrawals</h2>
      <p class="text-2xl"><?=$total_withdrawals?></p>
    </div>
  </div>

  <div class="mt-6 bg-white p-4 rounded shadow">
    <h2 class="font-bold mb-2">Recent Joins</h2>
    <table class="w-full text-left">
      <tr class="border-b"><th>User</th><th>Joined At</th></tr>
      <?php 
      $recent=$pdo->query("SELECT username, created_at FROM users ORDER BY created_at DESC LIMIT 5")->fetchAll();
      foreach($recent as $r){
        echo "<tr class='border-b'><td>{$r['username']}</td><td>{$r['created_at']}</td></tr>";
      }
      ?>
    </table>
  </div>
</div>

<?php include 'footer.php'; ?>
