<?php
// ================== BASIC CONFIG ==================
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();

// ====== DB CONFIG ======
$dbHost = "localhost";
$dbUser = "site5572_Bot111";
$dbPass = "site5572_Bot111";
$dbName = "site5572_Bot111";

// ====== TELEGRAM BOT CONFIG ======
$botToken    = "8017774373:AAHsrMEzFLFY_1ENNGO-chFaAiQ1xJjKI6c";
$botUserName = "Free_deposit_hunter98_bot";

// ====== ADMIN LOGIN PASSWORD ======
$ADMIN_PASSWORD = "tajeem123";

// ================== DB CONNECT ==================
$mysqli = new mysqli($dbHost, $dbUser, $dbPass, $dbName);
if ($mysqli->connect_errno) {
    die("DB Connection Failed: " . $mysqli->connect_error);
}

// ================== HELPERS ==================

// Telegram request helper
function sendTelegram($botToken, $method, $data)
{
    $url = "https://api.telegram.org/bot" . $botToken . "/" . $method;

    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL            => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST           => true,
        CURLOPT_POSTFIELDS     => $data,
        CURLOPT_TIMEOUT        => 20,
    ]);

    $response = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);

    if ($err) {
        return [false, $err];
    }

    $json = json_decode($response, true);
    if (!$json || empty($json['ok'])) {
        $desc = isset($json['description']) ? $json['description'] : 'unknown';
        return [false, $desc];
    }
    return [true, null];
}

// Upload ko URL me convert karna
function saveUploadAndGetUrl($fieldName)
{
    if (!isset($_FILES[$fieldName]) || $_FILES[$fieldName]['error'] !== UPLOAD_ERR_OK) {
        return null;
    }

    $tmpName = $_FILES[$fieldName]['tmp_name'];
    $orig    = $_FILES[$fieldName]['name'];

    $ext = pathinfo($orig, PATHINFO_EXTENSION);
    if ($ext === '') $ext = 'dat';

    $uploadDir = __DIR__ . '/uploads';
    if (!is_dir($uploadDir)) {
        @mkdir($uploadDir, 0775, true);
    }

    $fileName = $fieldName . '_' . time() . '_' . mt_rand(1000,9999) . '.' . $ext;
    $destPath = $uploadDir . '/' . $fileName;

    if (!move_uploaded_file($tmpName, $destPath)) {
        return null;
    }

    $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
    $host   = $_SERVER['HTTP_HOST'];

    $scriptDir = rtrim(str_replace('\\', '/', dirname($_SERVER['SCRIPT_NAME'])), '/');
    if ($scriptDir === '/' || $scriptDir === '\\') $scriptDir = '';

    $webPath = $scriptDir . '/uploads/' . $fileName;
    if ($webPath === '') $webPath = '/uploads/' . $fileName;

    return $scheme . '://' . $host . $webPath;
}

// ================== LOGIN SYSTEM ==================
if (isset($_POST['logout'])) {
    session_destroy();
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    if (isset($_POST['password'])) {
        if ($_POST['password'] === $ADMIN_PASSWORD) {
            $_SESSION['logged_in'] = true;
            header("Location: " . $_SERVER['PHP_SELF']);
            exit;
        } else {
            $login_error = "Galat password bhai 😅";
        }
    }

    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Bot Admin Login</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <style>
            * { box-sizing: border-box; }
            body {
                margin: 0;
                font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
                background: radial-gradient(circle at top, #1e293b, #020617);
                color: #e5e7eb;
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
            }
            .card {
                background: rgba(15, 23, 42, 0.98);
                border-radius: 18px;
                padding: 24px 22px 20px;
                width: 100%;
                max-width: 360px;
                box-shadow: 0 20px 40px rgba(0,0,0,0.6);
                border: 1px solid rgba(148,163,184,0.2);
                backdrop-filter: blur(10px);
            }
            .title {
                font-size: 20px;
                font-weight: 600;
                text-align: center;
                margin-bottom: 4px;
            }
            .subtitle {
                font-size: 13px;
                text-align: center;
                color: #9ca3af;
                margin-bottom: 18px;
            }
            label {
                font-size: 13px;
                color: #cbd5f5;
                display: block;
                margin-bottom: 6px;
            }
            input[type=password] {
                width: 100%;
                padding: 9px 11px;
                border-radius: 10px;
                border: 1px solid #1f2937;
                background: #020617;
                color: #e5e7eb;
                font-size: 14px;
                outline: none;
            }
            input[type=password]:focus {
                border-color: #6366f1;
                box-shadow: 0 0 0 1px rgba(129,140,248,0.6);
            }
            button {
                margin-top: 14px;
                width: 100%;
                padding: 10px;
                border: none;
                border-radius: 999px;
                background: linear-gradient(135deg, #6366f1, #22c55e);
                color: white;
                font-weight: 600;
                cursor: pointer;
                font-size: 14px;
            }
            button:hover {
                opacity: 0.96;
                transform: translateY(-1px);
            }
            .error {
                margin-top: 10px;
                padding: 8px 10px;
                border-radius: 8px;
                background: rgba(239,68,68,0.1);
                color: #fecaca;
                font-size: 13px;
            }
            .badge {
                display: inline-flex;
                align-items: center;
                gap: 6px;
                font-size: 11px;
                padding: 4px 8px;
                border-radius: 999px;
                background: rgba(37,99,235,0.15);
                color: #bfdbfe;
                margin: 0 auto 12px;
            }
            .dot {
                width: 6px;
                height: 6px;
                border-radius: 999px;
                background: #22c55e;
                box-shadow: 0 0 0 4px rgba(34,197,94,0.3);
            }
        </style>
    </head>
    <body>
        <div class="card">
            <div class="badge">
                <span class="dot"></span>
                <span>Secure Admin Access</span>
            </div>
            <div class="title">Telegram Bot Panel</div>
            <div class="subtitle">@<?php echo htmlspecialchars($botUserName); ?></div>
            <form method="post">
                <label>Admin Password</label>
                <input type="password" name="password" required placeholder="Enter admin password">
                <button type="submit">Login</button>
                <?php if (!empty($login_error)): ?>
                    <div class="error"><?php echo htmlspecialchars($login_error); ?></div>
                <?php endif; ?>
            </form>
        </div>
    </body>
    </html>
    <?php
    exit;
}

// ================== AFTER LOGIN ==================

// Hard-coded user table + chat column
$userTable    = "users";
$chatIdColumn = "telegram_id";

// Total UNIQUE users
$totalUsers = 0;
$resCount = $mysqli->query("SELECT COUNT(DISTINCT `$chatIdColumn`) AS c FROM `$userTable`");
if ($resCount) {
    $row = $resCount->fetch_assoc();
    $totalUsers = (int)$row['c'];
    $resCount->free();
}

// Handle broadcast
$broadcast_result = null;
$last_type = 'text';
$fail_reasons = [];
$start_from = 0;
$batch_size = 40;

if (isset($_POST['action']) && $_POST['action'] === 'broadcast') {
    set_time_limit(60);

    $messageType = $_POST['message_type'] ?? 'text';
    $last_type   = $messageType;
    $textMessage = trim($_POST['message'] ?? '');

    // Batch options
    $start_from = isset($_POST['start_from']) ? (int)$_POST['start_from'] : 0;
    $batch_size = isset($_POST['batch_size']) ? (int)$_POST['batch_size'] : 40;
    if ($start_from < 0) $start_from = 0;
    if ($batch_size < 1) $batch_size = 1;
    if ($batch_size > 80) $batch_size = 80; // safety

    $imageUrl = trim($_POST['image_url'] ?? '');
    $videoUrl = trim($_POST['video_url'] ?? '');
    $audioUrl = trim($_POST['audio_url'] ?? '');

    // Uploads -> URL
    if (!empty($_FILES['image_file']['name'])) {
        $u = saveUploadAndGetUrl('image_file');
        if ($u) $imageUrl = $u;
    }
    if (!empty($_FILES['video_file']['name'])) {
        $u = saveUploadAndGetUrl('video_file');
        if ($u) $videoUrl = $u;
    }
    if (!empty($_FILES['audio_file']['name'])) {
        $u = saveUploadAndGetUrl('audio_file');
        if ($u) $audioUrl = $u;
    }

    // Validation
    if ($messageType === 'text' && $textMessage === '') {
        $broadcast_result = "Error: Text message khali hai.";
    } elseif ($messageType === 'image' && $imageUrl === '') {
        $broadcast_result = "Error: Image mode ke liye photo upload ya Image URL chahiye.";
    } elseif ($messageType === 'video' && $videoUrl === '') {
        $broadcast_result = "Error: Video mode ke liye video upload ya Video URL chahiye.";
    } elseif ($messageType === 'audio' && $audioUrl === '') {
        $broadcast_result = "Error: Audio mode ke liye audio upload ya Audio URL chahiye.";
    }

    if ($broadcast_result === null) {
        $sqlUsers = "SELECT DISTINCT `$chatIdColumn` AS chat_id 
                     FROM `$userTable`
                     ORDER BY `$chatIdColumn` ASC
                     LIMIT $start_from, $batch_size";
        $resUsers = $mysqli->query($sqlUsers);

        if (!$resUsers) {
            $broadcast_result = "Error: User list fetch nahi ho rahi: " . $mysqli->error;
        } else {
            $chatIds = [];
            while ($row = $resUsers->fetch_assoc()) {
                if (!empty($row['chat_id'])) {
                    $chatIds[] = $row['chat_id'];
                }
            }
            $resUsers->free();

            if (empty($chatIds)) {
                $broadcast_result = "Is batch me koi user nahi mila (start_from: $start_from).";
            } else {
                $success = 0;
                $fail    = 0;
                $totalBatch = count($chatIds);

                foreach ($chatIds as $chatId) {
                    $ok  = false;
                    $err = null;

                    if ($messageType === 'text') {
                        list($ok, $err) = sendTelegram($botToken, "sendMessage", [
                            "chat_id"    => $chatId,
                            "text"       => $textMessage,
                            "parse_mode" => "HTML"
                        ]);
                    } elseif ($messageType === 'image') {
                        list($ok, $err) = sendTelegram($botToken, "sendPhoto", [
                            "chat_id"    => $chatId,
                            "photo"      => $imageUrl,
                            "caption"    => $textMessage,
                            "parse_mode" => "HTML"
                        ]);
                    } elseif ($messageType === 'video') {
                        list($ok, $err) = sendTelegram($botToken, "sendVideo", [
                            "chat_id"    => $chatId,
                            "video"      => $videoUrl,
                            "caption"    => $textMessage,
                            "parse_mode" => "HTML"
                        ]);
                    } elseif ($messageType === 'audio') {
                        list($ok, $err) = sendTelegram($botToken, "sendAudio", [
                            "chat_id"    => $chatId,
                            "audio"      => $audioUrl,
                            "caption"    => $textMessage,
                            "parse_mode" => "HTML"
                        ]);
                    }

                    if ($ok) {
                        $success++;
                    } else {
                        $fail++;
                        if ($err && count($fail_reasons) < 30) {
                            $fail_reasons[] = $chatId . " : " . $err;
                        }
                    }

                    usleep(80000); // 0.08 sec, thoda delay
                }

                $endIndex = $start_from + $totalBatch - 1;
                $nextStart = $start_from + $totalBatch;
                $broadcast_result =
                    "Batch complete ✅ Sent: $success / $totalBatch users ".
                    "(index $start_from – $endIndex) | Fail: $fail. ".
                    "Total users: $totalUsers. Next start_from: $nextStart";
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Bot Admin Panel</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * { box-sizing: border-box; }
        body {
            margin: 0;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            background: radial-gradient(circle at top, #0f172a, #020617);
            color: #e5e7eb;
            min-height: 100vh;
        }
        header {
            position: sticky;
            top: 0;
            z-index: 10;
            background: rgba(15,23,42,0.95);
            border-bottom: 1px solid rgba(148,163,184,0.25);
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 10px 18px;
            backdrop-filter: blur(18px);
        }
        .logo { display:flex; align-items:center; gap:10px; }
        .logo-circle {
            width: 30px; height: 30px; border-radius: 10px;
            background: conic-gradient(from 160deg,#22c55e,#6366f1,#0ea5e9,#22c55e);
            display:flex; align-items:center; justify-content:center;
            color:#0b1120; font-weight:700; font-size:16px;
        }
        .logo-text { display:flex; flex-direction:column; }
        .logo-title { font-size:15px; font-weight:600; }
        .logo-sub { font-size:11px; color:#9ca3af; }
        .header-right { display:flex; align-items:center; gap:8px; font-size:11px; }
        .tag {
            padding:3px 8px; border-radius:999px;
            background:rgba(15,118,110,0.25); color:#a5f3fc;
        }
        .logout-btn {
            border:none; padding:6px 12px; border-radius:999px;
            background:rgba(248,113,113,0.12); color:#fecaca;
            cursor:pointer; font-size:12px;
        }
        .logout-btn:hover { background:rgba(248,113,113,0.2); }

        .container {
            max-width: 960px; margin: 18px auto 28px;
            padding: 0 14px 24px;
        }
        .grid {
            display:grid;
            grid-template-columns:minmax(0,1.1fr) minmax(0,1.5fr);
            gap:16px;
        }
        @media (max-width:768px){
            .grid { grid-template-columns:minmax(0,1fr); }
        }
        .card {
            background:rgba(15,23,42,0.96);
            border-radius:16px;
            padding:16px 16px 14px;
            border:1px solid rgba(148,163,184,0.2);
            box-shadow:0 18px 40px rgba(15,23,42,0.7);
        }
        .card-header {
            display:flex; align-items:center;
            justify-content:space-between; margin-bottom:10px;
        }
        .card-title { font-size:15px; font-weight:600; }
        .card-badge {
            font-size:11px; padding:2px 7px; border-radius:999px;
            background:rgba(55,65,81,0.7); color:#e5e7eb;
        }
        .stat-number { font-size:26px; font-weight:700; margin-top:4px; }
        .stat-label { font-size:12px; color:#9ca3af; }
        .small-info { margin-top:8px; font-size:11px; color:#9ca3af; }
        .pill {
            display:inline-flex; align-items:center; gap:5px;
            padding:3px 8px; border-radius:999px;
            background:rgba(37,99,235,0.15); font-size:11px; margin-top:6px;
        }
        .dot-online {
            width:7px; height:7px; border-radius:999px;
            background:#22c55e; box-shadow:0 0 0 4px rgba(34,197,94,0.25);
        }

        label { font-size:12px; color:#cbd5f5; display:block; margin-bottom:4px; }
        .field { margin-bottom:10px; }
        textarea, input[type=text], input[type=file], input[type=number]{
            width:100%; padding:8px 10px; border-radius:10px;
            border:1px solid #1f2937; background:#020617;
            color:#e5e7eb; font-size:13px; outline:none;
        }
        textarea:focus, input[type=text]:focus, input[type=file]:focus, input[type=number]:focus{
            border-color:#6366f1; box-shadow:0 0 0 1px rgba(129,140,248,0.6);
        }
        textarea { resize:vertical; min-height:110px; }
        .radio-row {
            display:flex; flex-wrap:wrap; gap:10px;
            font-size:12px; margin-bottom:4px; margin-top:4px;
        }
        .radio-row label { display:flex; align-items:center; gap:5px; margin-bottom:0; }

        .btn-row {
            margin-top:10px; display:flex;
            align-items:center; justify-content:space-between; gap:10px;
        }
        .send-btn {
            flex:1; padding:9px 12px; border-radius:999px;
            border:none; background:linear-gradient(135deg,#22c55e,#16a34a);
            font-size:14px; font-weight:600; color:#f9fafb; cursor:pointer;
        }
        .send-btn:hover { opacity:0.97; transform:translateY(-1px); }
        .hint { font-size:11px; color:#9ca3af; text-align:right; }
        .result {
            margin-top:10px; padding:8px 10px; border-radius:10px;
            font-size:12px; background:rgba(15,118,110,0.15); color:#a5f3fc;
        }
        .result.error { background:rgba(248,113,113,0.15); color:#fecaca; }
        .mini { margin-top:8px; font-size:11px; color:#9ca3af; }
        .code-chip {
            display:inline-block; padding:2px 6px; border-radius:6px;
            background:rgba(15,23,42,0.9);
            border:1px solid rgba(55,65,81,0.8);
            font-family:monospace; font-size:11px;
        }
        .debug-box {
            margin-top:8px; padding:6px 8px; border-radius:8px;
            background:rgba(15,23,42,0.95);
            border:1px dashed rgba(148,163,184,0.6);
            max-height:160px; overflow:auto;
            font-size:11px; line-height:1.4; color:#e5e7eb;
        }
    </style>
</head>
<body>
<header>
    <div class="logo">
        <div class="logo-circle">B</div>
        <div class="logo-text">
            <div class="logo-title">Bot Admin Panel</div>
            <div class="logo-sub">@<?php echo htmlspecialchars($botUserName); ?></div>
        </div>
    </div>
    <div class="header-right">
        <div class="tag">Admin: Tajeem</div>
        <form method="post">
            <button type="submit" name="logout" class="logout-btn">Logout</button>
        </form>
    </div>
</header>

<div class="container">
    <div class="grid">
        <!-- LEFT STATS -->
        <div class="card">
            <div class="card-header">
                <div class="card-title">Overview</div>
                <div class="card-badge">Live Stats</div>
            </div>
            <div>
                <div class="stat-number"><?php echo $totalUsers; ?></div>
                <div class="stat-label">Total Unique Users (users.telegram_id)</div>
                <div class="small-info">
                    Table: <span class="code-chip">users</span>
                    &nbsp; Column: <span class="code-chip">telegram_id</span>
                </div>
                <div class="pill">
                    <span class="dot-online"></span>
                    <span>Bot Connected</span>
                </div>
                <div class="mini">
                    Broadcast ab <b>batch</b> me jayega.  
                    Example: pehle start_from=0, batch_size=40 → next time start_from=40.
                </div>
            </div>
        </div>

        <!-- RIGHT BROADCAST -->
        <div class="card">
            <div class="card-header">
                <div class="card-title">Broadcast Message</div>
                <div class="card-badge">Text / Media (Batch)</div>
            </div>

            <form method="post" enctype="multipart/form-data">
                <input type="hidden" name="action" value="broadcast">

                <div class="field">
                    <label>Message Type</label>
                    <div class="radio-row">
                        <label><input type="radio" name="message_type" value="text"  <?php echo ($last_type==='text'  ? 'checked' : ''); ?>>Text / Link</label>
                        <label><input type="radio" name="message_type" value="image" <?php echo ($last_type==='image' ? 'checked' : ''); ?>>Image + Caption</label>
                        <label><input type="radio" name="message_type" value="video" <?php echo ($last_type==='video' ? 'checked' : ''); ?>>Video + Caption</label>
                        <label><input type="radio" name="message_type" value="audio" <?php echo ($last_type==='audio' ? 'checked' : ''); ?>>Audio + Caption</label>
                    </div>
                </div>

                <div class="field">
                    <label>Message (Text / Caption)</label>
                    <textarea name="message" placeholder="Yaha apna message / caption likho. HTML allowed: &lt;b&gt;bold&lt;/b&gt;, &lt;a href='https://link'&gt;link&lt;/a&gt;"></textarea>
                </div>

                <div class="field">
                    <label>Batch Settings</label>
                    <div style="display:flex; gap:8px;">
                        <div style="flex:1;">
                            <small>Start from user # (0 se)</small>
                            <input type="number" name="start_from" value="<?php echo htmlspecialchars($start_from); ?>">
                        </div>
                        <div style="flex:1;">
                            <small>Batch size (max 80)</small>
                            <input type="number" name="batch_size" value="<?php echo htmlspecialchars($batch_size); ?>">
                        </div>
                    </div>
                    <div class="mini">Example: Total 91 users →  
                        1st run: start_from=0, size=40  
                        2nd run: start_from=40, size=40  
                        3rd run: start_from=80, size=40 (last 11 users)</div>
                </div>

                <div class="field">
                    <label>Upload Photo (Image type ke liye)</label>
                    <input type="file" name="image_file" accept="image/*">
                </div>
                <div class="field">
                    <label>Image URL (agar upload nahi karna)</label>
                    <input type="text" name="image_url" placeholder="https://example.com/image.jpg">
                </div>

                <div class="field">
                    <label>Upload Video (Video type ke liye)</label>
                    <input type="file" name="video_file" accept="video/*">
                </div>
                <div class="field">
                    <label>Video URL (agar upload nahi karna)</label>
                    <input type="text" name="video_url" placeholder="https://example.com/video.mp4">
                </div>

                <div class="field">
                    <label>Upload Audio (Audio type ke liye)</label>
                    <input type="file" name="audio_file" accept="audio/*">
                </div>
                <div class="field">
                    <label>Audio URL (agar upload nahi karna)</label>
                    <input type="text" name="audio_url" placeholder="https://example.com/audio.mp3">
                </div>

                <div class="btn-row">
                    <button type="submit" class="send-btn">Broadcast This Batch</button>
                    <div class="hint">Server safe rahe, isliye batch me send ho raha hai.</div>
                </div>

                <?php if ($broadcast_result !== null): ?>
                    <div class="result <?php echo (strpos($broadcast_result, 'Error:') === 0 ? 'error' : ''); ?>">
                        <?php echo htmlspecialchars($broadcast_result); ?>
                    </div>
                    <?php if (!empty($fail_reasons)): ?>
                        <div class="debug-box">
                            <strong>Fail users (max 30):</strong><br>
                            <?php foreach ($fail_reasons as $r) echo htmlspecialchars($r) . "<br>"; ?>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </form>
        </div>
    </div>
</div>
</body>
</html>
