<?php
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/../config.php';

$pdo = getDB();

// Approve/Reject action
if (isset($_GET['action']) && isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    $action = $_GET['action'];
    $status = ($action == 'approve') ? 'approved' : 'rejected';
    $stmt = $pdo->prepare("UPDATE withdrawals SET status=?, updated_at=NOW() WHERE id=?");
    $stmt->execute([$status, $id]);
    header("Location: withdrawals.php?msg=" . ucfirst($status));
    exit;
}

// Fetch withdrawals
$stmt = $pdo->query("SELECT * FROM withdrawals ORDER BY id DESC");
$withdrawals = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Withdrawals - Admin Panel</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #f2f6fc;
            margin: 0;
            padding: 0;
        }
        header {
            background: linear-gradient(90deg, #007bff, #6610f2);
            color: #fff;
            text-align: center;
            padding: 15px;
            font-size: 22px;
            font-weight: bold;
        }
        .container {
            max-width: 900px;
            margin: 30px auto;
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            padding: 12px 10px;
            border-bottom: 1px solid #eee;
            text-align: center;
        }
        th {
            background: #007bff;
            color: white;
        }
        tr:hover {
            background-color: #f8f9fa;
        }
        .btn {
            padding: 7px 14px;
            border-radius: 8px;
            text-decoration: none;
            color: white;
            font-weight: 600;
        }
        .approve {
            background-color: #28a745;
        }
        .reject {
            background-color: #dc3545;
        }
        .status {
            font-weight: bold;
            text-transform: capitalize;
        }
        .approved { color: #28a745; }
        .processing { color: #ffc107; }
        .rejected { color: #dc3545; }
        .footer {
            text-align: center;
            padding: 15px;
            color: #777;
            background: #f9fafc;
            font-size: 14px;
        }
        .msg {
            text-align: center;
            margin: 10px 0;
            font-weight: bold;
            color: #28a745;
        }
        @media(max-width:600px){
            table,thead,tbody,th,td,tr {display:block;}
            th {display:none;}
            td {border:none; padding:10px; text-align:left;}
            td::before {
                content: attr(data-label);
                font-weight: bold;
                display:block;
                color:#555;
            }
        }
    </style>
</head>
<body>
    <header>💸 Withdrawal Management</header>
    <div class="container">
        <?php if(isset($_GET['msg'])): ?>
            <div class="msg">✅ <?= htmlspecialchars($_GET['msg']) ?> successfully!</div>
        <?php endif; ?>

        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>User Telegram</th>
                    <th>Amount (₹)</th>
                    <th>UPI</th>
                    <th>Status</th>
                    <th>Requested</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
            <?php if($withdrawals): ?>
                <?php foreach($withdrawals as $w): ?>
                    <tr>
                        <td data-label="ID"><?= $w['id'] ?></td>
                        <td data-label="Telegram ID"><?= $w['user_telegram'] ?></td>
                        <td data-label="Amount">₹<?= $w['amount'] ?></td>
                        <td data-label="UPI"><?= htmlspecialchars($w['upi']) ?></td>
                        <td data-label="Status" class="status <?= $w['status'] ?>"><?= $w['status'] ?></td>
                        <td data-label="Date"><?= $w['created_at'] ?></td>
                        <td data-label="Action">
                            <?php if($w['status']=='processing'): ?>
                                <a href="?action=approve&id=<?= $w['id'] ?>" class="btn approve">Approve</a>
                                <a href="?action=reject&id=<?= $w['id'] ?>" class="btn reject">Reject</a>
                            <?php else: ?>
                                <span>—</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr><td colspan="7">No withdrawal requests found.</td></tr>
            <?php endif; ?>
            </tbody>
        </table>
    </div>
    <div class="footer">© 2025 Developer: Tajeem</div>
</body>
</html>
