<?php
session_start();
if(!isset($_SESSION['admin_logged_in'])){ header('Location: login.php'); exit; }

require_once 'db.php';
require_once 'config.php';
include 'header.php';

$pdo = getDB();
$msg = '';

// Add channel
if(isset($_POST['add'])){
    $title = trim($_POST['title']);
    $link  = trim($_POST['link']);
    if($title && $link){
        $stmt = $pdo->prepare('INSERT INTO channels (title, link, created_at) VALUES (?, ?, NOW())');
        $stmt->execute([$title, $link]);
        $msg = "Channel added successfully.";
    } else {
        $msg = "Please provide title and link.";
    }
}

// Delete channel
if(isset($_GET['delete'])){
    $id = (int)$_GET['delete'];
    $pdo->prepare('DELETE FROM channels WHERE id = ?')->execute([$id]);
    $msg = "Channel deleted.";
}

// Fetch channels
$channels = $pdo->query('SELECT * FROM channels ORDER BY id DESC')->fetchAll();

?>

<div class="container mx-auto p-4">
  <h1 class="text-2xl font-bold mb-4">Manage Channels</h1>

  <?php if($msg): ?>
    <div class="mb-4 p-3 rounded bg-green-100 text-green-800"><?=htmlspecialchars($msg)?></div>
  <?php endif; ?>

  <form method="POST" class="bg-white p-4 rounded shadow mb-6 grid gap-3 md:grid-cols-3">
    <input name="title" placeholder="Channel title" class="border p-2 rounded w-full md:col-span-1" required>
    <input name="link" placeholder="Channel link (https://t.me/...)" class="border p-2 rounded w-full md:col-span-1" required>
    <div class="md:col-span-1 flex items-center">
      <button name="add" class="bg-green-500 hover:bg-green-600 text-white px-4 py-2 rounded w-full">Add Channel</button>
    </div>
  </form>

  <div class="bg-white rounded shadow overflow-x-auto">
    <table class="min-w-full">
      <thead class="bg-gray-50">
        <tr>
          <th class="text-left p-3">ID</th>
          <th class="text-left p-3">Title</th>
          <th class="text-left p-3">Link</th>
          <th class="text-left p-3">Created</th>
          <th class="text-left p-3">Action</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($channels as $c): ?>
        <tr class="border-t hover:bg-gray-50">
          <td class="p-3"><?=htmlspecialchars($c['id'])?></td>
          <td class="p-3"><?=htmlspecialchars($c['title'])?></td>
          <td class="p-3"><a class="text-blue-600" href="<?=htmlspecialchars($c['link'])?>" target="_blank"><?=htmlspecialchars($c['link'])?></a></td>
          <td class="p-3"><?=htmlspecialchars($c['created_at'])?></td>
          <td class="p-3">
            <a href="?delete=<?=intval($c['id'])?>" class="text-red-600 hover:underline" onclick="return confirm('Delete this channel?')">Delete</a>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<?php include 'footer.php'; ?>
