<?php
// admin/index.php
session_start();
require_once __DIR__.'/../db.php';
require_once __DIR__.'/../config.php';
$pdo = getDB();

// login
if(isset($_POST['action']) && $_POST['action']=='login'){
    $user = $_POST['username'];
    $pass = $_POST['password'];
    $stmt = $pdo->prepare('SELECT * FROM admins WHERE username=?');
    $stmt->execute([$user]);
    $a = $stmt->fetch();
    if($a && password_verify($pass, $a['password'])){
        $_SESSION['admin']= $a['username'];
        header('Location: index.php'); exit;
    }else{
        $err='Invalid credentials';
    }
}

if(isset($_GET['logout'])){ session_destroy(); header('Location: index.php'); exit; }

if(!isset($_SESSION['admin'])){
    echo '<h2>Admin Login</h2>';
    if(isset($err)) echo '<div style="color:red;">'.$err.'</div>';
    echo '<form method="post"><input name="username" placeholder="username"><br><input name="password" type="password" placeholder="password"><br><button name="action" value="login">Login</button></form>';
    exit;
}

// admin dashboard
// fetch totals
$totalUsers = $pdo->query('SELECT COUNT(*) as c FROM users')->fetch()['c'];
$totalWithdrawals = $pdo->query("SELECT COUNT(*) as c FROM withdrawals WHERE status='pending'")->fetch()['c'];
$sumWithdrawn = $pdo->query("SELECT SUM(amount) as s FROM withdrawals WHERE status='approved'")->fetch()['s'] ?? 0;

// channels list
$channels = $pdo->query('SELECT * FROM channels')->fetchAll();

echo '<h1>Admin Panel</h1>';
echo '<a href="?logout=1">Logout</a>';
echo "<p>Total users: $totalUsers | Pending withdrawals: $totalWithdrawals | Paid: ₹$sumWithdrawn</p>";

// Channel management form
echo '<h3>Channels</h3>';
foreach($channels as $c){
    echo '<div style="border:1px solid #ddd;padding:8px;margin:8px">';
    echo '<b>'.$c['title'].'</b><br>'.$c['link'].'<br>';
    echo '<form method="post" action="actions.php" style="display:inline">';
    echo '<input type="hidden" name="delete_channel" value="'.$c['id'].'"><button>Delete</button></form>';
    echo '</div>';
}

// add channel
echo '<h4>Add Channel</h4>';
echo '<form method="post" action="actions.php"><input name="title" placeholder="Title"><input name="link" placeholder="Link"><button name="add_channel">Add</button></form>';

// Withdraw requests
$reqs = $pdo->query('SELECT w.*, u.username AS uname FROM withdrawals w LEFT JOIN users u ON u.telegram_id = w.user_telegram WHERE w.status = "pending"')->fetchAll();
echo '<h3>Withdraw Requests</h3>';
foreach($reqs as $r){
    echo '<div style="border:1px solid #ddd;padding:8px;margin:8px">';
    echo 'User: '.$r['user_telegram'].' ('.$r['uname'].')<br>';
    echo 'Amount: ₹'.$r['amount'].' | UPI: '.$r['upi'].'<br>';
    echo '<form method="post" action="actions.php" style="display:inline">';
    echo '<input type="hidden" name="wid" value="'.$r['id'].'">';
    echo '<button name="approve">Approve</button> <button name="reject">Reject</button>'; 
    echo '</form>';
    echo '</div>';
}

// Broadcast
echo '<h3>Broadcast</h3>';
echo '<form method="post" action="actions.php">';
echo '<textarea name="message" placeholder="Message to broadcast"></textarea><br>'; 
echo '<button name="broadcast">Send</button></form>';

?>
